package sample.run;

import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;

import com.nortel.soa.oi.cct.types.SsoToken;

import sample.subscribe.NotificationProducerSubscribe;
import sample.subscribe.UserSubscribe;

public class TestNotifications {

	public static void main(String[] args) throws Exception {
		
		String userName = "Agent1234";
		String password = "password!";
		String domain = "localhost";
		String cctServiceHostAndPort = "172.1.1.22:9180";
		String consumerPort = "9090";
		String consumerPort2 = "9078";
		 
		//User Input
		if (args!= null && args.length == 6) {
			userName = args[0];
			password = args[1];
			domain = args[2];
			cctServiceHostAndPort = args[3];
			consumerPort = args[4];
			consumerPort2 = args[5];
		}
		
		
		//Simple subscribe for all events via user service
		UserSubscribe us = new UserSubscribe(consumerPort, cctServiceHostAndPort);
		//String consumerEndpoint = us.publishNotificationConsumer();

		//Login to get SSO TOKENT
		SsoToken ssoToken = us.loginToCctServer(userName, password, domain);
		//String subscription1 = us.simpleSubscribe(consumerEndpoint, ssoToken);
		
		//Subscribe for Agent Property Notifications via notification producer
		NotificationProducerSubscribe nps = new NotificationProducerSubscribe(consumerPort2, cctServiceHostAndPort, ssoToken);
		String consumerEndpoint2 = nps.publishNotificationConsumer();
		EndpointReferenceType subscription2 = nps.subscribe(consumerEndpoint2, ssoToken);
		 
		//Sleep for 30 seconds so we can inject events
		Thread.sleep(30000);
		
		//Unsubsribe
		//us.unsubscribe(subscription1, ssoToken);
		nps.unsubscribe(subscription2, ssoToken);
		
		//Sleep to ensure notifications done
		Thread.sleep(1000);
		
		//Logout
		us.logout(ssoToken);
		
		
	}
}
